/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.data;

import frc.emul.config.data.CfgItemKernel;
import frc.emul.vectrex.ui.opengl.BlurShaderUtils;
import java.util.ArrayList;
import java.util.List;

public class CfgItemShaderGlow {
    public static final int DEFAULT_PASSES = 3;
    public static final boolean DEFAULT_GAIN_H = false;
    public static final boolean DEFAULT_GAIN_V = true;
    public static final float DEFAULT_GAIN_H_FACTOR = 1.0f;
    public static final float DEFAULT_GAIN_V_FACTOR = 1.35f;
    public static final boolean DEFAULT_FLICKERING = true;
    public static final float DEFAULT_FLICKERING_FACTOR = 0.2f;
    public static final boolean DEFAULT_ATTENUATION = true;
    public static final float DEFAULT_ATTENUATION_FACTOR = 2.5f;
    public static final int DEFAULT_HORIZ_KERNEL_SIZE = 5;
    public static final int DEFAULT_VERT_KERNEL_SIZE = 5;
    public static final boolean DEFAULT_BUFSIZE_MODE = true;
    public static final float DEFAULT_BUFSIZE_FACTOR = 1.0f;
    public static final int DEFAULT_BUFSIZE_HEIGHT = 800;
    public static final int DEFAULT_BUFSIZE_WIDTH = 640;
    public static final int MIN_BUFFER_HEIGHT = 32;
    public static final int MIN_BUFFER_WIDTH = 25;
    private final List<CfgItemKernel> kernels = new ArrayList<CfgItemKernel>(2);
    public boolean active;
    public int passes;
    public boolean hGain;
    public boolean vGain;
    public float hGainFactor;
    public float vGainFactor;
    public float bufferSizeFactor;
    public int bufferFixedHeight;
    public int bufferFixedWidth;
    public boolean isBufferFixedSize;
    public boolean attenuation;
    public float attenuationFactor;
    public boolean flickering;
    public float flickeringFactor;
    public String author;
    public String description;

    public CfgItemShaderGlow() {
        this.kernels.add(new CfgItemKernel("horizontal"));
        this.kernels.add(new CfgItemKernel("vertical"));
        this.reset();
        this.active = true;
    }

    public CfgItemShaderGlow(CfgItemShaderGlow cfgItemShaderGlow, boolean bl) {
        this.clone(cfgItemShaderGlow, bl);
        this.active = cfgItemShaderGlow.active;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(this.active ? "ON " : "OFF ").append("pass=").append(this.passes).append(" gainH=(").append(this.hGain ? (char)'+' : '-').append(',').append(this.hGainFactor).append(')').append(" gainV=(").append(this.vGain ? (char)'+' : '-').append(',').append(this.vGainFactor).append(')').append(" atten=(").append(this.attenuation ? (char)'+' : '-').append(',').append(this.attenuationFactor).append(')').append(" flicker=(").append(this.flickering ? (char)'+' : '-').append(',').append(this.flickeringFactor).append(')').append(" size=(").append(this.isBufferFixedSize ? (char)'F' : 'R').append(',').append(this.bufferFixedWidth).append('x').append(this.bufferFixedHeight).append(',').append(this.bufferSizeFactor).append(')').append(' ').append(this.getHorizonalKernel()).append(' ').append(this.getVerticalKernel());
        return stringBuilder.toString();
    }

    public void clone(CfgItemShaderGlow cfgItemShaderGlow, boolean bl) {
        this.hGain = cfgItemShaderGlow.hGain;
        this.vGain = cfgItemShaderGlow.vGain;
        this.passes = cfgItemShaderGlow.passes;
        this.flickering = cfgItemShaderGlow.flickering;
        this.attenuation = cfgItemShaderGlow.attenuation;
        this.hGainFactor = cfgItemShaderGlow.hGainFactor;
        this.vGainFactor = cfgItemShaderGlow.vGainFactor;
        this.flickeringFactor = cfgItemShaderGlow.flickeringFactor;
        this.attenuationFactor = cfgItemShaderGlow.attenuationFactor;
        this.isBufferFixedSize = cfgItemShaderGlow.isBufferFixedSize;
        this.bufferFixedWidth = cfgItemShaderGlow.bufferFixedWidth;
        this.bufferFixedHeight = cfgItemShaderGlow.bufferFixedHeight;
        this.bufferSizeFactor = cfgItemShaderGlow.bufferSizeFactor;
        this.author = cfgItemShaderGlow.author;
        this.description = cfgItemShaderGlow.description;
        this.kernels.clear();
        if (bl) {
            this.kernels.addAll(cfgItemShaderGlow.kernels);
        } else {
            for (CfgItemKernel cfgItemKernel : cfgItemShaderGlow.kernels) {
                this.kernels.add(new CfgItemKernel(cfgItemKernel));
            }
        }
    }

    public void reset() {
        this.hGain = false;
        this.vGain = true;
        this.passes = 3;
        this.flickering = true;
        this.attenuation = true;
        this.hGainFactor = 1.0f;
        this.vGainFactor = 1.35f;
        this.flickeringFactor = 0.2f;
        this.attenuationFactor = 2.5f;
        this.isBufferFixedSize = true;
        this.bufferFixedWidth = 640;
        this.bufferFixedHeight = 800;
        this.bufferSizeFactor = 1.0f;
        this.getHorizonalKernel().setHalfMatrix(BlurShaderUtils.createLinearKernel(5));
        this.getVerticalKernel().setHalfMatrix(BlurShaderUtils.createLinearKernel(5));
    }

    public CfgItemKernel getHorizonalKernel() {
        return this.getKernel("horizontal");
    }

    public CfgItemKernel getVerticalKernel() {
        return this.getKernel("vertical");
    }

    public CfgItemKernel getKernel(String string) {
        for (CfgItemKernel cfgItemKernel : this.kernels) {
            if (!cfgItemKernel.getID().equalsIgnoreCase(string)) continue;
            return cfgItemKernel;
        }
        return null;
    }
}

